package com.seuic.scanner.service.settings;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.seuic.settings.R;

public class MainActivity extends Activity implements OnClickListener {

	private final String ACTION_SCANNER_APP_SETTINGS = "com.android.scanner.service_settings";

	private final String TYPE_PLAYSOUND = "sound_play";
	private final String TYPE_VIBERATE = "viberate";
	private final String TYPE_SCAN_ENABLED = "enabled";// Enable/disable scan
	private final String TYPE_SCAN_CONTINUE = "scan_continue";// Continuous scan
	private final String TYPE_INTERVAL = "interval";// Continuous scanning interval
	private final String TYPE_PREFIX = "prefix";// barcode prefix
	private final String TYPE_SUFFIX = "suffix";// barcode postfix
	private final String TYPE_BOOT_START = "boot_start";
	private final String TYPE_END_CHAR = "endchar";
	private final String TYPE_BARCODE_SEND_MODE = "barcode_send_mode";
	private final String TYPE_BARCODE_BROADCAST_ACTION = "action_barcode_broadcast";
	private final String TYPE_BARCODE_BROADCAST_KEY = "key_barcode_broadcast";
	private final String TYPE_FILTER_PREFIX_SUFFIX_BLANK = "filter_prefix_suffix_blank";	// trim spaces at heading and tailing of the barcode
	private final String TYPE_FILTER_INVISIBLE_CHARS = "filter_invisible_chars"; 	// filter invisible chars
	private final String ACTION_SCANNER_PARAMETER_SETTINGS = "com.seuic.scanner.action.PARAM_SETTINGS"; // action: set scanner parameters
	private final String TYPE_PARAMETER_NUMBER = "number";	// parameter index
	private final String TYPE_PARAMETER_VALUE = "value";	// parameter value
	private final String ACTION_SCANNER_ENABLED = "com.android.scanner.ENABLED"; // action: enable/disable scan

	private Button mBtnPSEnable;
	private Button mBtnPSDisable;
	private Button mBtnVBEnable;
	private Button mBtnVBDisable;
	private Button mBtnBSEnable;
	private Button mBtnBSDisable;
	private Button mBtnFPSBEnable;
	private Button mBtnFPSBDisable;
	private Button mBtnSetEndChar;
	private Button mBtnSetSendMode;
	private Button mBtnSetBCName;
	private Button mBtnSetBCKey;
	private Button mBtnContinueEnable;
	private Button mBtnContinueDisable;
	private Button mBtnSetInterval;
	private Button mBtnSetPrefix;
	private Button mBtnSetSuffix;
	private Button mBtnSetParam;
	private Button mBtnSetScanEnabled;
	private Button mBtnSetScanDisabled;
	private Button mBtnSetFilterInvisibleCharsEnabled;
	private Button mBtnSetFilterInvisibleCharsDisabled;
	private Spinner mSpnEndChar;
	private Spinner mSpnSendMode;
	private EditText mEdtBCName;
	private EditText mEdtBCKey;
	private TextView mTextParamNum;
	private TextView mTextParamValue;
	private TextView mTextInterval;
	private TextView mTextPrefix;
	private TextView mTextSuffix;
	private MainActivity mInstance;

	private SendMode[] mSendModes = SendMode.values();
	private EndChar[] mEndChars = EndChar.values();

	private ArrayAdapter<SendMode> mSendModeAdapter;
	private ArrayAdapter<EndChar> mEndCharAdapter;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		mInstance = this;

		mBtnBSDisable = (Button) findViewById(R.id.btn_bootstart_disable);
		mBtnBSDisable.setOnClickListener(this);

		mBtnBSEnable = (Button) findViewById(R.id.btn_bootstart_enable);
		mBtnBSEnable.setOnClickListener(this);

		mBtnPSDisable = (Button) findViewById(R.id.btn_playsound_disable);
		mBtnPSDisable.setOnClickListener(this);

		mBtnPSEnable = (Button) findViewById(R.id.btn_playsound_enable);
		mBtnPSEnable.setOnClickListener(this);

		mBtnSetScanEnabled = (Button) findViewById(R.id.btn_scan_enable);
		mBtnSetScanEnabled.setOnClickListener(this);

		mBtnSetScanDisabled = (Button) findViewById(R.id.btn_scan_disable);
		mBtnSetScanDisabled.setOnClickListener(this);

		mBtnSetFilterInvisibleCharsEnabled = (Button) findViewById(R.id.btn_filter_invisible_chars_enabled);
		mBtnSetFilterInvisibleCharsEnabled.setOnClickListener(this);

		mBtnSetFilterInvisibleCharsDisabled = (Button) findViewById(R.id.btn_filter_invisible_chars_disabled);
		mBtnSetFilterInvisibleCharsDisabled.setOnClickListener(this);

		mBtnFPSBDisable = (Button) findViewById(R.id.btn_filter_presuf_blank_disable);
		mBtnFPSBDisable.setOnClickListener(this);

		mBtnFPSBEnable = (Button) findViewById(R.id.btn_filter_presuf_blank_enable);
		mBtnFPSBEnable.setOnClickListener(this);

		mBtnSetBCKey = (Button) findViewById(R.id.btn_set_broadcast_key);
		mBtnSetBCKey.setOnClickListener(this);

		mBtnSetBCName = (Button) findViewById(R.id.btn_set_broadcast_name);
		mBtnSetBCName.setOnClickListener(this);

		mBtnSetEndChar = (Button) findViewById(R.id.btn_set_endchar);
		mBtnSetEndChar.setOnClickListener(this);

		mBtnSetSendMode = (Button) findViewById(R.id.btn_set_sendmode);
		mBtnSetSendMode.setOnClickListener(this);

		mBtnVBDisable = (Button) findViewById(R.id.btn_viberate_disable);
		mBtnVBDisable.setOnClickListener(this);

		mBtnVBEnable = (Button) findViewById(R.id.btn_viberate_enable);
		mBtnVBEnable.setOnClickListener(this);

		mBtnContinueEnable = (Button) findViewById(R.id.btn_scan_continue_open);// 连续扫描
		mBtnContinueEnable.setOnClickListener(this);
		mBtnContinueDisable = (Button) findViewById(R.id.btn_scan_continue_close);
		mBtnContinueDisable.setOnClickListener(this);
		mBtnSetInterval = (Button) findViewById(R.id.btn_set_interval);// 时间间隔
		mBtnSetInterval.setOnClickListener(this);
		mBtnSetPrefix = (Button) findViewById(R.id.btn_set_prefix);// 条码前缀
		mBtnSetPrefix.setOnClickListener(this);
		mBtnSetSuffix = (Button) findViewById(R.id.btn_set_suffix);// 条码后缀
		mBtnSetSuffix.setOnClickListener(this);
		mBtnSetParam = (Button) findViewById(R.id.btn_set_param); //条码参数设置
		mBtnSetParam.setOnClickListener(this);
		mTextParamNum = (TextView)findViewById(R.id.edt_param_id);
		mTextParamValue = (TextView)findViewById(R.id.edt_param_value);
		mTextInterval = (TextView) findViewById(R.id.edt_interval);
		mTextPrefix = (TextView) findViewById(R.id.edt_prefix);
		mTextSuffix = (TextView) findViewById(R.id.edt_suffix);
		mSpnEndChar = (Spinner) findViewById(R.id.spn_endchar);
		mEndCharAdapter = new ArrayAdapter<EndChar>(this, android.R.layout.simple_spinner_dropdown_item,
				mEndChars);
		mEndCharAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		mSpnEndChar.setAdapter(mEndCharAdapter);

		mSpnSendMode = (Spinner) findViewById(R.id.spn_sendmode);
		mSendModeAdapter = new ArrayAdapter<SendMode>(this, android.R.layout.simple_spinner_dropdown_item,
				mSendModes);
		mSendModeAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		mSpnSendMode.setAdapter(mSendModeAdapter);
		mSpnSendMode.setSelection(SendMode.valueOf("BROADCAST").ordinal());

		mEdtBCName = (EditText) findViewById(R.id.edt_broadcast_name);
		mEdtBCName.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				final EditText edt = new EditText(mInstance);
				edt.setText(mEdtBCName.getText().toString());
				AlertDialog dialog = new AlertDialog.Builder(mInstance).setTitle(R.string.broadcast_name).setView(edt)
						.setPositiveButton(R.string.OK, new DialogInterface.OnClickListener() {

					@Override
					public void onClick(DialogInterface dialog, int which) {
						String bcName = edt.getText().toString();
						if (!TextUtils.isEmpty(bcName)) {
							mEdtBCName.setText(bcName);
						} else {
							Toast.makeText(mInstance, R.string.the_broadcast_name_must_not_be_empty, Toast.LENGTH_SHORT).show();
						}
					}

				}).create();
				dialog.show();
			}
		});

		mEdtBCKey = (EditText) findViewById(R.id.edt_broadcast_key);
		mEdtBCKey.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				final EditText edt = new EditText(mInstance);
				edt.setText(mEdtBCKey.getText().toString());
				AlertDialog dialog = new AlertDialog.Builder(mInstance).setTitle(R.string.broadcast_key).setView(edt)
						.setPositiveButton(R.string.OK, new DialogInterface.OnClickListener() {

					@Override
					public void onClick(DialogInterface dialog, int which) {
						String bcKey = edt.getText().toString();
						if (!TextUtils.isEmpty(bcKey)) {
							mEdtBCKey.setText(bcKey);
						} else {
							Toast.makeText(mInstance, R.string.the_broadcast_key_value_must_not_be_empty, Toast.LENGTH_SHORT).show();
						}
					}

				}).create();
				dialog.show();
			}
		});
	}

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
			case R.id.btn_bootstart_disable:
				setBootStart(false);
				break;
			case R.id.btn_bootstart_enable:
				setBootStart(true);
				break;
			case R.id.btn_playsound_disable:
				setPlaySound(false);
				break;
			case R.id.btn_playsound_enable:
				setPlaySound(true);
				break;
			case R.id.btn_filter_presuf_blank_disable:
				setFilterPreSufferBlank(false);
				break;
			case R.id.btn_filter_presuf_blank_enable:
				setFilterPreSufferBlank(true);
				break;
			case R.id.btn_set_broadcast_key:
				setBCKey();
				break;
			case R.id.btn_set_broadcast_name:
				setBCName();
				break;
			case R.id.btn_set_endchar:
				setEndChar();
				break;
			case R.id.btn_set_sendmode:
				setSendMode();
				break;
			case R.id.btn_viberate_disable:
				setViberate(false);
				break;
			case R.id.btn_viberate_enable:
				setViberate(true);
				break;
			case R.id.btn_scan_continue_open:// 连续扫描
				setContinue(true);
				break;
			case R.id.btn_scan_continue_close:
				setContinue(false);
				break;
			case R.id.btn_set_interval:// 时间间隔
				int timeInterval = Integer.valueOf(mTextInterval.getText().toString());
				setInterval(timeInterval);
				break;
			case R.id.btn_set_prefix:// 条码前缀
				String prefix = mTextPrefix.getText().toString();
				setPrefix(prefix);
				break;
			case R.id.btn_set_suffix:// 条码后缀
				String suffix = mTextSuffix.getText().toString();
				setSuffix(suffix);
				break;
			case R.id.btn_set_param:
				int number = Integer.valueOf(mTextParamNum.getText().toString());
				int value = Integer.valueOf(mTextParamValue.getText().toString());
				if (number > -1 && value > -1) {
					setParam(number, value);
				}
				break;
			case R.id.btn_scan_enable:
				setScanEnabled(true);
				break;
			case R.id.btn_scan_disable:
				setScanEnabled(false);
				break;
			case R.id.btn_filter_invisible_chars_enabled:
				setFilterInvisibleChars(true);
				break;
			case R.id.btn_filter_invisible_chars_disabled:
				setFilterInvisibleChars(false);
				break;
		}
	}

	private void setParam(int id, int value) {
		Intent intent = new Intent(ACTION_SCANNER_PARAMETER_SETTINGS);
		intent.putExtra(TYPE_PARAMETER_NUMBER, id);
		intent.putExtra(TYPE_PARAMETER_VALUE, value);
		sendBroadcast(intent);
	}

	private void setPlaySound(boolean enable) {
		Intent intent = newIntent().putExtra(TYPE_PLAYSOUND, enable);
		sendBroadcast(intent);
	}

	private void setFilterPreSufferBlank(boolean enable){//过滤首尾空格
		Intent intent = newIntent().putExtra(TYPE_FILTER_PREFIX_SUFFIX_BLANK, enable);
		sendBroadcast(intent);
	}

	private void setFilterInvisibleChars(boolean enable) {
		Intent intent = newIntent().putExtra(TYPE_FILTER_INVISIBLE_CHARS, enable);
		sendBroadcast(intent);
	}

	private void setViberate(boolean enable) {
		Intent intent = newIntent().putExtra(TYPE_VIBERATE, enable);
		sendBroadcast(intent);
	}

	private void setScanEnabled(boolean enabled) { //enable/disable Scanner
		Intent intent = new Intent(ACTION_SCANNER_ENABLED);
		intent.putExtra(TYPE_SCAN_ENABLED, enabled);
		sendBroadcast(intent);
	}

	private void setContinue(boolean enable) {// 连续扫描
		Intent intent = newIntent().putExtra(TYPE_SCAN_CONTINUE, enable);
		sendBroadcast(intent);
	}

	private void setInterval(int timeInterval) {// 时间间隔
		Intent intent = newIntent().putExtra(TYPE_INTERVAL, timeInterval);
		sendBroadcast(intent);
	}

	private void setPrefix(String prefix) {// 条码前缀
		Intent intent = newIntent().putExtra(TYPE_PREFIX, prefix);
		sendBroadcast(intent);
	}

	private void setSuffix(String suffix) {// 条码后缀
		Intent intent = newIntent().putExtra(TYPE_SUFFIX, suffix);
		sendBroadcast(intent);
	}

	private void setBootStart(boolean enable) {
		Intent intent = newIntent().putExtra(TYPE_BOOT_START, enable);
		sendBroadcast(intent);
	}

	private void setEndChar() {
		String endChar = mSpnEndChar.getSelectedItem().toString();
		Intent intent = newIntent().putExtra(TYPE_END_CHAR, endChar);
		sendBroadcast(intent);
	}

	private void setSendMode() {
		String sendMode = mSpnSendMode.getSelectedItem().toString();
		Intent intent = newIntent().putExtra(TYPE_BARCODE_SEND_MODE, sendMode);
		sendBroadcast(intent);
	}

	private void setBCName() {
		String bcName = mEdtBCName.getText().toString();
		Intent intent = newIntent().putExtra(TYPE_BARCODE_BROADCAST_ACTION, bcName);
		sendBroadcast(intent);
	}

	private void setBCKey() {
		String bcKey = mEdtBCKey.getText().toString();
		Intent intent = newIntent().putExtra(TYPE_BARCODE_BROADCAST_KEY, bcKey);
		sendBroadcast(intent);
	}

	private Intent newIntent() {
		Intent intent = new Intent(ACTION_SCANNER_APP_SETTINGS);
		return intent;
	}

	public enum SendMode {
		FOCUS, BROADCAST, EMUKEY, CLIPBOARD
	}

	public enum EndChar {
		ENTER, TAB, SPACE, NONE
	}
}
